/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.render.effects;

import com.eeeab.eeeabsmobs.client.render.EERenderType;
import com.eeeab.eeeabsmobs.sever.entity.impl.effect.EntityGuardianLaser;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderGuardianLaser
extends EntityRenderer<EntityGuardianLaser> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("eeeabsmobs", "textures/effects/guardian_laser.png");
    private static final float TEXTURE_WIDTH = 256.0f;
    private static final float TEXTURE_HEIGHT = 32.0f;
    private static final float GUARDIAN_START_RADIUS = 1.09f;
    private static final float PLAYER_START_RADIUS = 0.8f;
    private static final float GUARDIAN_BEAM_RADIUS = 0.9f;
    private static final float PLAYER_BEAM_RADIUS = 0.6f;
    private boolean playerView;
    private boolean isPlayer;

    public RenderGuardianLaser(EntityRendererProvider.Context mgr) {
        super(mgr);
    }

    public ResourceLocation getTextureLocation(EntityGuardianLaser entity) {
        return TEXTURE;
    }

    public void render(EntityGuardianLaser laser, float entityYaw, float delta, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        this.playerView = laser.caster instanceof Player && Minecraft.m_91087_().f_91074_ == laser.caster && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON;
        this.isPlayer = laser.isPlayer() || laser.caster instanceof Player;
        double collidePosX = laser.prevCollidePosX + (laser.collidePosX - laser.prevCollidePosX) * (double)delta;
        double collidePosY = laser.prevCollidePosY + (laser.collidePosY - laser.prevCollidePosY) * (double)delta;
        double collidePosZ = laser.prevCollidePosZ + (laser.collidePosZ - laser.prevCollidePosZ) * (double)delta;
        double posX = laser.f_19854_ + (laser.m_20185_() - laser.f_19854_) * (double)delta;
        double posY = laser.f_19855_ + (laser.m_20186_() - laser.f_19855_) * (double)delta;
        double posZ = laser.f_19856_ + (laser.m_20189_() - laser.f_19856_) * (double)delta;
        float yaw = laser.prevYHeadRotAngle + (laser.yHeadRotAngle - laser.prevYHeadRotAngle) * delta;
        float pitch = laser.prevXHeadRotAngle + (laser.xHeadRotAngle - laser.prevXHeadRotAngle) * delta;
        float length = (float)Math.sqrt(Math.pow(collidePosX - posX, 2.0) + Math.pow(collidePosY - posY, 2.0) + Math.pow(collidePosZ - posZ, 2.0));
        int frame = Mth.m_14143_((float)(((float)(laser.displayControlled.getTimer() - 1) + delta) * 2.0f));
        if (frame < 0) {
            frame = 6;
        }
        VertexConsumer vertex$builder = bufferIn.m_6299_(EERenderType.getGlowingEffect(this.getTextureLocation(laser)));
        this.renderStart(frame, matrixStackIn, vertex$builder, packedLightIn);
        this.renderBeam(length, 57.295776f * yaw, 57.295776f * pitch, frame, matrixStackIn, vertex$builder, packedLightIn);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(collidePosX - posX, collidePosY - posY, collidePosZ - posZ);
        this.renderEnd(frame, laser.blockSide, matrixStackIn, vertex$builder, packedLightIn);
        matrixStackIn.m_85849_();
    }

    private void renderFlatQuad(int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn, boolean inGround) {
        float minU = 0.0f + 0.0625f * (float)frame;
        float minV = 0.0f;
        float maxU = minU + 0.0625f;
        float maxV = minV + 0.5f;
        float SIZE = !this.isPlayer ? 1.09f + (inGround ? 0.2f : 0.0f) : 0.8f;
        PoseStack.Pose matrix$stack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrix$stack$entry.m_85861_();
        Matrix3f matrix3f = matrix$stack$entry.m_85864_();
        this.drawVertex(matrix4f, matrix3f, builder, -SIZE, -SIZE, 0.0f, minU, minV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -SIZE, SIZE, 0.0f, minU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, SIZE, SIZE, 0.0f, maxU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, SIZE, -SIZE, 0.0f, maxU, minV, 1.0f, packedLightIn);
    }

    private void renderStart(int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        if (this.playerView) {
            return;
        }
        matrixStackIn.m_85836_();
        Quaternion quaternionf = this.f_114476_.m_114470_();
        matrixStackIn.m_85845_(quaternionf);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn, false);
        matrixStackIn.m_85849_();
    }

    private void renderEnd(int frame, Direction side, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        matrixStackIn.m_85836_();
        Quaternion quat = this.f_114476_.m_114470_();
        matrixStackIn.m_85845_(quat);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn, false);
        matrixStackIn.m_85849_();
        if (side == null) {
            return;
        }
        matrixStackIn.m_85836_();
        Quaternion rotation = side.m_122406_();
        rotation.m_80148_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStackIn.m_85845_(rotation);
        matrixStackIn.m_85837_(0.0, 0.0, (double)-0.01f);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn, true);
        matrixStackIn.m_85849_();
    }

    private void drawBeam(float length, int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        float minU = 0.0f;
        float minV = 0.5f + 0.03125f * (float)frame;
        float maxU = minU + 0.078125f;
        float maxV = minV + 0.03125f;
        PoseStack.Pose matrix$stack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrix$stack$entry.m_85861_();
        Matrix3f matrix3f = matrix$stack$entry.m_85864_();
        float offset = this.playerView ? -1.0f : 0.0f;
        float SIZE = this.isPlayer ? 0.6f : 0.9f;
        this.drawVertex(matrix4f, matrix3f, builder, -SIZE, offset, 0.0f, minU, minV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -SIZE, length, 0.0f, minU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, SIZE, length, 0.0f, maxU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, SIZE, offset, 0.0f, maxU, minV, 1.0f, packedLightIn);
    }

    private void renderBeam(float length, float yaw, float pitch, int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(yaw - 90.0f));
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-pitch));
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(Minecraft.m_91087_().f_91063_.m_109153_().m_90589_() + 90.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(-Minecraft.m_91087_().f_91063_.m_109153_().m_90589_() - 90.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(-Minecraft.m_91087_().f_91063_.m_109153_().m_90589_() + 180.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(-Minecraft.m_91087_().f_91063_.m_109153_().m_90589_() - 180.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85849_();
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLightIn) {
        vertexBuilder.m_85982_(matrix, offsetX, offsetY, offsetZ).m_85950_(1.0f, 1.0f, 1.0f, 1.0f * alpha).m_7421_(textureX, textureY).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normals, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

